package gov.va.med.mhv.usermgmt.messages;

public interface UserManagementMessages {

	public static final String FACILITY_NOT_FOUND = "facility.not.found";
	public static final String USER_NOT_FOUND = "user.not.found";
	public static final String INVALID_HINTS  = "invalid.hints";
	public static final String INVALID_SEARCH_FIELDS  = "invalid.search.field.combo";
	public static final String INVALID_USER_ID  = "invalid.userid";
	public static final String NO_USERS_FOUND  = "no.users.found";
	public static final String CURRENT_AND_NEW_USER_NAMES_MUST_DIFFER = "current.and.new.user.names.must.differ";
	public static final String PASSWORD_NOT_CONFIRM = "password.not.confirm";
	public static final String PATIENT_REGISTRY_ACCESS_ERROR = "patient.registry.access.error";
	public static final String HINTS_MUST_DIFFER = "hints.must.differ";
	public static final String SSN_REQUIRED_FOR_PATIENT = "ssn.required.for.patient";

	//CR2161 and CR2162 Kumar,Vyasa
	public static final String HINTS_ANSWER_REQUIRED  ="password.hint.answer.required";
	public static final String HINTS_ANSWER_MUST_DIFFER  ="password.hint.answer.differ";
	public static final String HINTS_ANSWER_ONE  ="password.hint.answerone";
	public static final String HINTS_ANSWER_TWO  ="password.hint.answertwo";
	//US8.15 & US7.15 - SSN is required if Relationship to VA is or has changed to Veteran and/or VA Patient.
	public static final String SSN_REQUIRED_FOR_VETERAN = "ssn.required.for.veteran";

	public static final String MISSING_USER_TYPE = "user.profile.missing.user.type";
	public static final String SUCCESSFUL_REGISTRATION = "user.successful.registration";
	public static final String MUST_ACCEPT_TERMS = "user.must.accept.terms";
	public static final String MUST_ACCEPT_PRIVACY = "user.must.accept.privacy";
	public static final String MUST_ACCEPT_DISCLAIMER = "user.must.accept.disclaimer";
	public static final String HEALTH_INTEREST_EMAIL_REQUIRED = "user.health.interest.email.required";
	public static final String SSN_DOES_NOT_MATCH = "user.ssn.does.not.match";
	public static final String USER_ALREADY_IN_USE = "user.already.in.use";
	public static final String TERMS_NOT_ACCEPTED = "not.accept.terms";

	//US8.16 & US7.16 - Last name is not blank and contains no numbers.
	public static final String LAST_NAME_NUMBERS = "last.name.numbers";

	// Address messages
	public static final String STATE_REQUIRED = "address.state.required";
	public static final String COUNTRY_REQUIRED = "address.country.required";
	public static final String PROVINCE_REQUIRED = "address.province.required";

	public static final String PROVINCE_OR_STATE = "address.province.or.state";

	// Contact info messages
	public static final String CONTACT_METHOD_NOT_SPECIFIED = "contact.method.not.specified";

	public static final String LOGIN_FAILED 				= "user.login.failed";
	public static final String USER_ALREADY_EXISTS 			= "user.already.exists";
	public static final String USER_DOES_NOT_EXIST 			= "user.does.not.exist";
	public static final String INVALID_CREDENTIALS 			= "invalid.credentials";
	public static final String ACCOUNT_LOCKED 				= "account.locked";
    public static final String ACCOUNT_DEACTIVATED          = "account.deactivated";
	public static final String USERNAME_PASSWORD_REQUIRED 	= "username.password.required";
	public static final String USERNAME_INVALID_LENGTH 		= "username.invalid.length";
	public static final String USERNAME_NOT_ALPHANUMERIC 	= "username.not.alphanumeric";
	public static final String USERNAME_PASSWORD_EQUAL 		= "user.name.password.equal";
	public static final String PASSWORD_INVALID_LENGTH 		= "password.invalid.length";
	public static final String PASSWORD_SPACES_NOT_ALLOWED 	= "password.spaces.not.allowed";
	public static final String PASSWORD_NO_SPECIAL_CHAR 	= "password.no.special.char";
	public static final String PASSWORD_NO_LETTER 			= "password.no.letter";
	public static final String PASSWORD_NO_DIGIT 			= "password.no.digit";
	public static final String CURRENT_PASSWORD_INVALID     = "current.password.invalid";
	public static final String CURRENT_PASSWORD_EXPIRED     = "current.password.expired";
	public static final String CURRENT_PASSWORD_TEMPORARY   = "current.password.temporary";
	public static final String PASSWORD_USED			    = "password.used";
	public static final String PASSWORD_CHANGED			    = "password.changed.successfully";

	public static final String BLUEBUTTON_INVALID_SEARCH_CRITERIA_1 = "user.invalid.search.criteria.dataclasses.1";
	public static final String BLUEBUTTON_INVALID_SEARCH_CRITERIA_2 = "user.invalid.search.criteria.dataclasses.2";

}
